/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWMapListCellRenderer;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWUsersDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWDesignerParticipantListCellRenderer;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.security.IVWParticipantSelectionDialog;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersAndGroupsDialog;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VWReceiveAdvancedPanel
extends JPanel
implements ActionListener,
IVWExpressionTextFieldListener,
IVWMapChangedListener,
ListSelectionListener {
    private VWExpressionTextField m_timeoutExpression = null;
    private JComboBox m_timeoutMapComboBox = null;
    private JRadioButton m_yesRB = null;
    private JRadioButton m_noRB = null;
    private JLabel m_acceptMessagesFromLabel = null;
    private JButton m_editSecurityGroupButton = null;
    private JButton m_deleteSecurityGroupButton = null;
    private VWSortedListModel m_securityGroupListModel = null;
    private JList m_securityGroupList = null;
    private JDialog m_parentDialog = null;
    private Frame m_parentFrame = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWReceiveInstruction m_instructionDef = null;
    private IVWParticipantSelectionDialog m_usersAndGroupsDialog = null;

    public VWReceiveAdvancedPanel(JDialog parentDialog, VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_parentDialog = parentDialog;
        this.createControls();
    }

    public VWReceiveAdvancedPanel(Frame parentFrame, VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_parentFrame = parentFrame;
        this.createControls();
    }

    public void setInstructionDefinition(VWReceiveInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src.equals(this.m_timeoutMapComboBox)) {
            this.performTimeoutMapAction();
        } else if (src.equals(this.m_yesRB)) {
            this.performAuthenticationAction(true);
        } else if (src.equals(this.m_noRB)) {
            this.performAuthenticationAction(false);
        } else if (this.m_editSecurityGroupButton != null && src.equals(this.m_editSecurityGroupButton)) {
            this.onAddSecurityGroupButton();
        } else if (this.m_deleteSecurityGroupButton != null && src.equals(this.m_deleteSecurityGroupButton)) {
            this.onDeleteSecurityGroupButton();
        }
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        Object src = event.getSource();
        if (src == this.m_timeoutExpression) {
            this.updateTimeout();
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 516: 
            case 517: 
            case 519: {
                this.initTimeoutMapComboBox();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (this.m_securityGroupList != null && event.getSource().equals(this.m_securityGroupList) && this.m_deleteSecurityGroupButton != null) {
            this.m_deleteSecurityGroupButton.setEnabled(!this.m_securityGroupListModel.isEmpty() && this.m_securityGroupList.getSelectedIndex() != -1);
        }
    }

    protected void reinitialize() {
        if (this.m_instructionDef != null) {
            this.initTimeoutMapComboBox();
            this.initSecurityGroupList();
            this.m_timeoutExpression.removeExpressionTextFieldListener(this);
            this.m_timeoutExpression.setText(this.m_instructionDef.getTimeoutExpr());
            this.m_timeoutExpression.addExpressionTextFieldListener(this);
            boolean isAuth = this.m_instructionDef.getAuthentication();
            this.m_yesRB.removeActionListener(this);
            this.m_noRB.removeActionListener(this);
            if (this.m_securityGroupList != null) {
                this.m_securityGroupList.removeListSelectionListener(this);
            }
            if (isAuth) {
                this.m_yesRB.setSelected(true);
                this.m_noRB.setSelected(false);
                if (this.m_acceptMessagesFromLabel != null) {
                    this.m_acceptMessagesFromLabel.setEnabled(true);
                }
                if (this.m_editSecurityGroupButton != null) {
                    this.m_editSecurityGroupButton.setEnabled(true);
                }
                if (this.m_deleteSecurityGroupButton != null) {
                    this.m_deleteSecurityGroupButton.setEnabled(!this.m_securityGroupListModel.isEmpty() && this.m_securityGroupList.getSelectedIndex() != -1);
                }
                if (this.m_securityGroupList != null) {
                    this.m_securityGroupList.setEnabled(true);
                }
            } else {
                this.m_yesRB.setSelected(false);
                this.m_noRB.setSelected(true);
                if (this.m_acceptMessagesFromLabel != null) {
                    this.m_acceptMessagesFromLabel.setEnabled(false);
                }
                if (this.m_editSecurityGroupButton != null) {
                    this.m_editSecurityGroupButton.setEnabled(false);
                }
                if (this.m_deleteSecurityGroupButton != null) {
                    this.m_deleteSecurityGroupButton.setEnabled(false);
                }
                if (this.m_securityGroupList != null) {
                    this.m_securityGroupList.setEnabled(false);
                }
            }
            this.m_noRB.addActionListener(this);
            this.m_yesRB.addActionListener(this);
            if (this.m_securityGroupList != null) {
                this.m_securityGroupList.addListSelectionListener(this);
            }
        }
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(5, 5, 0, 5);
            VWToolbarBorder timeoutExpressionBorder = new VWToolbarBorder(VWResource.s_timeoutExpression);
            JPanel timeoutPanel = timeoutExpressionBorder.getClientPanel();
            timeoutPanel.setLayout(new BorderLayout());
            this.m_timeoutExpression = this.m_parentDialog != null ? new VWExpressionTextField(this.m_parentDialog, (IVWPropertyData)this.m_authPropertyData) : new VWExpressionTextField(this.m_parentFrame, (IVWPropertyData)this.m_authPropertyData);
            this.m_timeoutExpression.addExpressionTextFieldListener(this);
            timeoutPanel.add(this.m_timeoutExpression);
            this.add((Component)timeoutExpressionBorder, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 5, 0, 5);
            VWToolbarBorder timeoutMapBorder = new VWToolbarBorder(VWResource.s_timeoutMap);
            JPanel timeoutMapPanel = timeoutMapBorder.getClientPanel();
            timeoutMapPanel.setLayout(new BorderLayout());
            this.m_timeoutMapComboBox = new JComboBox();
            this.m_timeoutMapComboBox.setRenderer(new VWMapListCellRenderer(this.m_authPropertyData));
            this.m_timeoutMapComboBox.addActionListener(this);
            timeoutMapPanel.add(this.m_timeoutMapComboBox);
            this.add((Component)timeoutMapBorder, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 10, 5);
            this.add((Component)this.getAuthenticationPanel(), gbCons);
            ++gbCons.gridx;
            this.add((Component)new JLabel(" "), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
    }

    private JPanel getAuthenticationPanel() {
        VWToolbarBorder authenticationBorder = new VWToolbarBorder(VWResource.s_authentication);
        JPanel authenticationPanel = authenticationBorder.getClientPanel();
        authenticationPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(5, 5, 0, 5);
        this.m_noRB = new JRadioButton(VWResource.s_no);
        this.m_noRB.setSelected(true);
        this.m_noRB.addActionListener(this);
        authenticationPanel.add((Component)this.m_noRB, gbCons);
        ++gbCons.gridx;
        this.m_yesRB = new JRadioButton(VWResource.s_yes);
        this.m_yesRB.setSelected(false);
        this.m_yesRB.addActionListener(this);
        authenticationPanel.add((Component)this.m_yesRB, gbCons);
        ButtonGroup authenticationGrp = new ButtonGroup();
        authenticationGrp.add(this.m_noRB);
        authenticationGrp.add(this.m_yesRB);
        if (this.m_authPropertyData.getShowParticipants()) {
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(5, 17, 0, 5);
            this.m_acceptMessagesFromLabel = new JLabel(VWResource.s_acceptMessagesFrom);
            authenticationPanel.add((Component)this.m_acceptMessagesFromLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(5, 5, 0, 5);
            this.m_editSecurityGroupButton = (JButton)VWImageLoader.createToolBarButton("update.gif", VWResource.s_modify, false);
            this.m_editSecurityGroupButton.addActionListener(this);
            authenticationPanel.add((Component)this.m_editSecurityGroupButton, gbCons);
            ++gbCons.gridx;
            this.m_deleteSecurityGroupButton = (JButton)VWImageLoader.createToolBarButton("delete.gif", VWResource.s_deleteStr, false);
            this.m_deleteSecurityGroupButton.addActionListener(this);
            authenticationPanel.add((Component)this.m_deleteSecurityGroupButton, gbCons);
            gbCons.gridx -= 2;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 0;
            gbCons.insets = new Insets(0, 17, 0, 0);
            this.m_securityGroupListModel = new VWSortedListModel();
            this.m_securityGroupList = new JList(this.m_securityGroupListModel);
            this.m_securityGroupList.setCellRenderer(new VWDesignerParticipantListCellRenderer());
            this.m_securityGroupList.addListSelectionListener(this);
            authenticationPanel.add((Component)new JScrollPane(this.m_securityGroupList), gbCons);
        }
        return authenticationBorder;
    }

    private void initTimeoutMapComboBox() {
        Object[] mapNames = null;
        Vector<String> mapNamesVec = new Vector<String>();
        this.m_timeoutMapComboBox.removeActionListener(this);
        try {
            if (this.m_authPropertyData != null) {
                this.m_timeoutMapComboBox.removeAllItems();
                this.m_timeoutMapComboBox.addItem(VWResource.s_noneItemStr);
                this.m_timeoutMapComboBox.addItem("Workflow");
                this.m_timeoutMapComboBox.addItem("Malfunction");
                this.m_timeoutMapComboBox.addItem("Terminate");
                VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions();
                if (mapDefs != null) {
                    int len = mapDefs.length;
                    for (int i = 0; i < len; ++i) {
                        String mapName = mapDefs[i].getName();
                        if (VWStringUtils.compare(mapName, "Workflow") == 0 || VWStringUtils.compare(mapName, "Malfunction") == 0 || VWStringUtils.compare(mapName, "Terminate") == 0) continue;
                        mapNamesVec.addElement(mapName);
                    }
                    mapNames = new String[mapNamesVec.size()];
                    mapNamesVec.copyInto(mapNames);
                }
                if (mapNames != null && mapNames.length > 0) {
                    VWQubbleSort.sort(mapNames);
                    for (int i = 0; i < mapNames.length; ++i) {
                        Object mapName = mapNames[i];
                        if (VWStringUtils.compareIgnoreCase((String)mapName, "") == 0) continue;
                        this.m_timeoutMapComboBox.addItem(mapName);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        String selectedMapName = null;
        if (this.m_instructionDef != null) {
            selectedMapName = this.m_instructionDef.getTimeoutMapName();
        }
        if (selectedMapName != null && selectedMapName.length() > 0) {
            this.m_timeoutMapComboBox.setSelectedItem(selectedMapName);
            String selected = (String)this.m_timeoutMapComboBox.getSelectedItem();
            if (VWStringUtils.compare(selected, selectedMapName) != 0) {
                this.m_timeoutMapComboBox.addItem(selectedMapName);
                this.m_timeoutMapComboBox.setSelectedItem(selectedMapName);
            }
        } else {
            this.m_timeoutMapComboBox.setSelectedIndex(0);
        }
        this.m_timeoutMapComboBox.addActionListener(this);
    }

    private void initSecurityGroupList() {
        VWParticipant[] vwParticipants = null;
        VWParticipantItem[] vwParticipantItems = null;
        try {
            String[] names = this.m_instructionDef.getSecurityGroup();
            if (names != null && names.length > 0) {
                vwParticipants = new VWParticipant[names.length];
                for (int i = 0; i < names.length; ++i) {
                    vwParticipants[i] = !names[i].startsWith("\"") ? new VWParticipant("\"" + names[i] + "\"") : new VWParticipant(names[i]);
                }
            }
            vwParticipantItems = VWDefaultSessionProxy.getQuotedFullParticipantItems(vwParticipants, true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            vwParticipantItems = VWDefaultSessionProxy.getParticipantItemsUsingParticipants(vwParticipants, true);
        }
        this.updateSecurityGroupList(vwParticipantItems);
    }

    private void updateSecurityGroupList(VWParticipantItem[] participantItems) {
        try {
            if (this.m_securityGroupListModel == null) {
                return;
            }
            this.m_securityGroupListModel.removeAllElements();
            if (participantItems != null && participantItems.length > 0) {
                for (int i = 0; i < participantItems.length; ++i) {
                    this.m_securityGroupListModel.addElement(participantItems[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateTimeout() {
        try {
            String timeout = this.m_timeoutExpression.getText();
            if (timeout != null && timeout.length() == 0) {
                timeout = null;
            }
            this.m_instructionDef.setTimeoutExpr(timeout);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performTimeoutMapAction() {
        try {
            String map = (String)this.m_timeoutMapComboBox.getSelectedItem();
            if (VWStringUtils.compare(map, VWResource.s_noneItemStr) == 0) {
                map = null;
            }
            this.m_instructionDef.setTimeoutMapName(map);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAuthenticationAction(boolean isAuth) {
        try {
            this.m_instructionDef.setAuthentication(isAuth);
            if (!isAuth) {
                if (this.m_acceptMessagesFromLabel != null) {
                    this.m_acceptMessagesFromLabel.setEnabled(false);
                }
                if (this.m_editSecurityGroupButton != null) {
                    this.m_editSecurityGroupButton.setEnabled(false);
                }
                if (this.m_deleteSecurityGroupButton != null) {
                    this.m_deleteSecurityGroupButton.setEnabled(false);
                }
                if (this.m_securityGroupList != null) {
                    this.m_securityGroupList.setEnabled(false);
                }
                if (this.m_securityGroupListModel != null) {
                    this.m_securityGroupListModel.clear();
                }
                this.m_instructionDef.setSecurityGroup(null);
            } else {
                if (this.m_acceptMessagesFromLabel != null) {
                    this.m_acceptMessagesFromLabel.setEnabled(true);
                }
                if (this.m_editSecurityGroupButton != null) {
                    this.m_editSecurityGroupButton.setEnabled(true);
                }
                if (this.m_deleteSecurityGroupButton != null) {
                    this.m_deleteSecurityGroupButton.setEnabled(!this.m_securityGroupListModel.isEmpty() && this.m_securityGroupList.getSelectedIndex() != -1);
                }
                if (this.m_securityGroupList != null) {
                    this.m_securityGroupList.setEnabled(true);
                }
            }
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onAddSecurityGroupButton() {
        try {
            VWSession vwSession = this.m_authPropertyData.getVWSession();
            if (vwSession != null) {
                if (this.m_usersAndGroupsDialog == null) {
                    this.m_usersAndGroupsDialog = vwSession.getSecurityDatabaseType() == 1 ? new VWFilteredUsersAndGroupsDialog(this.m_authPropertyData.getMainContainer(), vwSession) : new VWUsersDialog(this.m_authPropertyData.getMainContainer(), vwSession);
                }
                Object[] objects = this.m_securityGroupListModel.toArray();
                VWParticipantItem[] items = null;
                if (objects != null && objects.length > 0) {
                    items = new VWParticipantItem[objects.length];
                    System.arraycopy(objects, 0, items, 0, objects.length);
                }
                this.m_usersAndGroupsDialog.init(items, (String)null);
                this.m_usersAndGroupsDialog.setVisible(true);
                if (this.m_usersAndGroupsDialog.getStatus() == 1) {
                    String[] namesArray = null;
                    VWParticipantItem[] participantItems = this.m_usersAndGroupsDialog.getParticipants();
                    if (participantItems != null && participantItems.length > 0) {
                        VWParticipant[] tempParticipants = VWDefaultSessionProxy.getParticipantsFromParticipantItems(participantItems, true);
                        participantItems = VWDefaultSessionProxy.getParticipantItemsUsingParticipants(tempParticipants, true);
                        namesArray = new String[participantItems.length];
                        for (int nIndex = 0; nIndex < participantItems.length; ++nIndex) {
                            namesArray[nIndex] = participantItems[nIndex].getShortName();
                        }
                    }
                    this.m_instructionDef.setSecurityGroup(namesArray);
                    this.updateSecurityGroupList(participantItems);
                    this.m_authPropertyData.setDirty();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    private void onDeleteSecurityGroupButton() {
        try {
            int[] selectedIndices = this.m_securityGroupList.getSelectedIndices();
            if (selectedIndices != null && this.m_instructionDef != null) {
                int nTotalSelectedCount = selectedIndices.length;
                int nParticipantListSize = this.m_securityGroupListModel.getSize();
                for (int nIndex = nParticipantListSize - 1; nIndex >= 0; --nIndex) {
                    for (int selectedIndex = 0; selectedIndex < selectedIndices.length; ++selectedIndex) {
                        if (nIndex != selectedIndices[selectedIndex]) continue;
                        this.m_securityGroupListModel.removeElementAt(selectedIndices[selectedIndex]);
                        if (--nTotalSelectedCount == 0) break;
                    }
                    if (nTotalSelectedCount == 0) break;
                }
                if (this.m_securityGroupListModel.getSize() == 0) {
                    this.m_instructionDef.setSecurityGroup(null);
                } else {
                    String[] names = new String[this.m_securityGroupListModel.getSize()];
                    for (int x = 0; x < this.m_securityGroupListModel.getSize(); ++x) {
                        VWParticipantItem pItem = (VWParticipantItem)this.m_securityGroupListModel.getElementAt(x);
                        names[x] = pItem.getShortName();
                    }
                    this.m_instructionDef.setSecurityGroup(names);
                }
                this.m_authPropertyData.setDirty();
                if (this.m_deleteSecurityGroupButton != null) {
                    this.m_deleteSecurityGroupButton.setEnabled(!this.m_securityGroupListModel.isEmpty() && this.m_securityGroupList.getSelectedIndex() != -1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

